local assets =
{
	Asset("ANIM", "anim/glass.zip"),
    Asset("ATLAS", "images/inventoryimages/glass.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("glass")
    inst.AnimState:SetBuild("glass")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "glass"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/glass.xml"
    inst:AddComponent("selfstacker")
	inst.Transform:SetScale(2, 2, 2)

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("glass", fn, assets)